package ru.yandex.chemodan.app.dataapi.core.generic;

import org.junit.Test;

import ru.yandex.chemodan.app.dataapi.test.UnitTestBase;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.FormatConverter;
import ru.yandex.misc.test.Assert;

/**
 * @author Denis Bakharev
 */
public class FormatConverterCacheTest extends UnitTestBase {

    private final FormatConverterCache cache = new FormatConverterCache();
    private final String schema =
            "{\n"
            + "    \"type\": \"object\",\n"
            + "    \"properties\": {\n"
            + "        \"prop1\": {\n"
            + "            \"type\": \"string\"\n"
            + "        }\n"
            + "    }\n"
            + "}";

    @Test
    public void returnsNewConverterWithEmptyCache() {
        FormatConverter converter = cache.getConverter(getTypeSettings(schema));
        Assert.equals(schema, converter.jsonSchema);
    }

    @Test
    public void returnsNewConverterIfNewJsonSchema() {
        FormatConverter oldConverter = cache.getConverter(getTypeSettings(schema));
        String newSchema = schema.replaceAll("prop1", "prop2");
        FormatConverter newConverter = cache.getConverter(getTypeSettings(newSchema));
        Assert.equals(newSchema, newConverter.jsonSchema);
        Assert.notEquals(oldConverter, newConverter);
    }

    @Test
    public void returnsOldConverterIfJsonSchemaNotChanged() {
        FormatConverter oldConverter = cache.getConverter(getTypeSettings(schema));
        FormatConverter newConverter = cache.getConverter(getTypeSettings(schema));
        Assert.equals(oldConverter, newConverter);
    }
}
