package ru.yandex.chemodan.app.dataapi.core.generic;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.DatabaseChangedEventHandler;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.PatchableSnapshot;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChange;

/**
 * @author Denis Bakharev
 */
@AllArgsConstructor
public abstract class GenericObjectChangedEventHandler implements DatabaseChangedEventHandler {

    private final TypeSettingsRegistry typeSettingsRegistry;

    @Override
    public ListF<RecordChange> databaseChanged(PatchableSnapshot snapshot) {
        ListF<RecordChange> result = Cf.list();

        for (DataRecord recordAtEnd : snapshot.patchedRecords) {
            Option<TypeSettings> typeSettingsO = typeSettingsRegistry.getTypeSettings(
                    new TypeLocation(snapshot.database(), recordAtEnd.getCollectionId()));

            if (typeSettingsO.isPresent()) {
                Option<DataRecord> recordsAtStart = snapshot.initialSnapshot.getRecordO(recordAtEnd.id);
                result = handleGenericObjectRecordChanged(recordsAtStart, recordAtEnd, typeSettingsO.get());
            }
        }

        return result;
    }

    public abstract ListF<RecordChange> handleGenericObjectRecordChanged(
            Option<DataRecord> recordAtStart, DataRecord recordAtEnd, TypeSettings typeSettings);
}
