package ru.yandex.chemodan.app.dataapi.core.generic;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.datasource.DataSourceType;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.db.ref.UserDatabaseSpec;
import ru.yandex.chemodan.app.dataapi.api.deltas.DeltasJdbcDao;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiPassportUserId;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.core.dao.data.DatabasesJdbcDao;
import ru.yandex.chemodan.util.test.TestAppsAndUsers;
import ru.yandex.misc.test.Assert;

/**
 * @author Denis Bakharev
 */
public class GenericObjectManagerTest extends GenericObjectManagerTestBase {

    @Autowired
    private DatabasesJdbcDao databasesDao;

    @Autowired
    private DeltasJdbcDao deltasDao;

    @Test
    public void updateObjectOfPassportStuckDatabase() {
        DataApiUserId uid = new DataApiPassportUserId(TestAppsAndUsers.testingUser2.uid);
        userInitializer.initUserForTests(uid, false);

        TypeSettings ts = GenericObjectManagerTest.ts.withTypeLocation(new TypeLocation(Option.of("pass"), "db", "col"));
        typeSettingsRegistry.setTypeSettings(ts);

        dataSourceTypeRegistry.setMigrating(ts.dbRef(), DataSourceType.DISK, DataSourceType.PASSPORT);
        dataSourceTypeRegistry.setMigrated(ts.dbRef());

        String firstValue = "{\"requiredProp\":\"first\",\"key\":\"recId\"}";
        String lastValue = "{\"requiredProp\":\"last\",\"key\":\"recId\"}";

        genericObjectManager.set(uid, recId, ts.typeName, firstValue);
        Assert.equals(firstValue, genericObjectManager.get(uid, recId, ts.typeName));

        Database db = dataApiManager.getDatabase(new UserDatabaseSpec(uid, ts.dbRef()));

        databasesDao.save(db.withRev(db.rev - 1), db.rev);
        deltasDao.delete(uid, db.handleValue(), db.rev - 1);

        Assert.equals(firstValue, genericObjectManager.get(uid, recId, ts.typeName));

        genericObjectManager.set(uid, recId, ts.typeName, lastValue);
        Assert.equals(lastValue, genericObjectManager.get(uid, recId, ts.typeName));
    }
}
