package ru.yandex.chemodan.app.dataapi.core.generic;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataFieldType;

/**
 * @author Denis Bakharev
 */
public class GenericObjectUtils {

    public static Option<Instant> calculateDeletionDate(
            MapF<String, DataField> genericObjectData,
            DeletionSettings ds)
    {
        Option<Instant> sourceDate = findFirstDate(ds.getDatePaths(), genericObjectData);
        Option<Instant> deletionDate = sourceDate.map(d -> d.withDurationAdded(ds.getDeletionInterval(), 1));
        return deletionDate;
    }

    private static Option<Instant> findFirstDate(ListF<String> datePaths, MapF<String, DataField> genericObjectData) {
        Option<Instant> sourceDateO = Option.empty();
        for(String datePath : datePaths) {
            sourceDateO = findDeletionDate(DataField.map(genericObjectData), datePath.split("/"), 0);
            if(sourceDateO.isPresent()) {
                break;
            }
        }
        return sourceDateO;
    }

    private static Option<Instant> findDeletionDate(
            DataField dataField,
            String[] pathParts,
            int pathIndex)
    {
        if(pathIndex == pathParts.length) {
            switch (dataField.fieldType) {
                case TIMESTAMP:
                    return Option.of(dataField.timestampValue());
                case DATETIME:
                    return Option.of(dataField.dateTimeValue().toInstant());
            }
        } else if(dataField.fieldType == DataFieldType.MAP) {
            Option<DataField> child = dataField.mapValue().getO(pathParts[pathIndex]);
            if(child.isPresent()) {
                return findDeletionDate(child.get(), pathParts, pathIndex + 1);
            }
        }

        return Option.empty();
    }
}
