package ru.yandex.chemodan.app.dataapi.core.generic;

import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.misc.test.Assert;

/**
 * @author Denis Bakharev
 */
public class GenericObjectUtilsTest {
    private final Instant now = Instant.now();
    private final String path = "a/b";
    private final Duration deletionInterval = Duration.standardDays(1);
    private final DeletionSettings ds = new DeletionSettings(path, deletionInterval);
    private MapF<String, DataField> dataFields = Cf.hashMap();

    @Test
    public void calculateDeletionDate_InstantExists_ReturnsExpectedDate() {

        dataFields.put("a", DataField.map(Cf.<String, DataField>hashMap().plus1("b", DataField.timestamp(now))));

        Option<Instant> deletionDate = GenericObjectUtils.calculateDeletionDate(dataFields, ds);

        Assert.notEmpty(deletionDate);
        Assert.equals(now.withDurationAdded(deletionInterval, 1),  deletionDate.get());
    }

    @Test
    public void calculateDeletionDate_DateTimeExists_ReturnsExpectedDate() {
        dataFields.put("a",
                DataField.map(Cf.<String, DataField>hashMap().plus1("b", DataField.dateTime(now.toDateTime()))));

        Option<Instant> deletionDate = GenericObjectUtils.calculateDeletionDate(dataFields, ds);

        Assert.notEmpty(deletionDate);
        Assert.equals(now.withDurationAdded(deletionInterval, 1),  deletionDate.get());
    }

    @Test
    public void calculateDeletionDate_MultiplePaths_ReturnsExpectedDate() {
        dataFields.put("c",
                DataField.map(Cf.<String, DataField>hashMap().plus1("d", DataField.dateTime(now.toDateTime()))));

        String datePaths = "a/b;c/d";
        DeletionSettings deletionSettings = new DeletionSettings(datePaths, deletionInterval);
        Option<Instant> deletionDate = GenericObjectUtils.calculateDeletionDate(dataFields, deletionSettings);

        Assert.notEmpty(deletionDate);
        Assert.equals(now.withDurationAdded(deletionInterval, 1),  deletionDate.get());
    }

    @Test
    public void calculateDeletionDate_NoDataExists_ReturnsNone() {
        dataFields.put("a", DataField.map(Cf.<String, DataField>hashMap()));
        Option<Instant> deletionDate = GenericObjectUtils.calculateDeletionDate(dataFields, ds);
        Assert.isEmpty(deletionDate);
    }
}
