package ru.yandex.chemodan.app.dataapi.core.generic;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;

import ru.yandex.chemodan.app.dataapi.api.db.ref.external.ExternalDatabasesRegistry;
import ru.yandex.chemodan.app.dataapi.core.generic.bazinga.GenericObjectDeletionTask;
import ru.yandex.chemodan.app.dataapi.core.generic.loader.DataRecordsLoader;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.commune.bazinga.BazingaTaskManager;

/**
 * @author Denis Bakharev
 */
@Profile("dataapi")
@Configuration
@Import(value = {
        TypeSettingsRegistryContextConfiguration.class
})
public class GenericObjectsContextConfiguration {

    @Bean
    public GenericObjectManager genericDataManager(
            DataApiManager dataApiManager,
            TypeSettingsRegistry typeSettingsRegistry,
            FormatConverterCache formatConverterCache,
            BazingaTaskManager bazingaTaskManager,
            DataRecordsLoader dataRecordsLoader,
            ExternalDatabasesRegistry externalDatabasesRegistry)
    {
        return new GenericObjectManager(
                dataApiManager,
                typeSettingsRegistry,
                formatConverterCache,
                bazingaTaskManager,
                dataRecordsLoader,
                externalDatabasesRegistry);
    }

    @Bean
    public FormatConverterCache formatConverterCache() {
        return new FormatConverterCache();
    }

    @Bean
    public GenericObjectsValidator genericObjectsValidator(
            TypeSettingsRegistry typeSettingsRegistry, FormatConverterCache formatConverterCache)
    {
        return new GenericObjectsValidator(typeSettingsRegistry, formatConverterCache);
    }

    @Bean
    public ScheduleObjectDeletionHandler deletionTaskScheduler(
            BazingaTaskManager bazingaTaskManager, TypeSettingsRegistry typeSettingsRegistry)
    {
        return new ScheduleObjectDeletionHandler(bazingaTaskManager, typeSettingsRegistry);
    }

    @Bean
    public GenericObjectDeletionTask genericObjectDeletionTask(GenericObjectManager genericObjectManager) {
        return new GenericObjectDeletionTask(genericObjectManager);
    }
}
