package ru.yandex.chemodan.app.dataapi.core.generic;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.test.UnitTestBase;

import static org.mockito.Mockito.mock;

/**
 * @author Denis Bakharev
 */
public class GenericObjectsValidatorTest extends UnitTestBase {

    @Test
    public void validateTwoRequiredProps() {
        GenericObjectsValidator validator =
                new GenericObjectsValidator(mock(TypeSettingsRegistry.class), new FormatConverterCache());

        String jsonSchema =
                "{\n"
                + "    \"type\": \"object\",\n"
                + "    \"properties\": {\n"
                + "        \"id\": {\n"
                + "            \"type\": \"string\"\n"
                + "        },\n"
                + "        \"requiredProp1\": {\n"
                + "            \"type\": \"string\"\n"
                + "        },\n"
                + "        \"requiredProp2\": {\n"
                + "            \"type\": \"string\"\n"
                + "        }\n"
                + "    },\n"
                + "    \"required\": [\n"
                + "        \"id\",\n"
                + "        \"requiredProp1\",\n"
                + "        \"requiredProp2\"\n"
                + "    ]\n"
                + "}";

        MapF<String, DataField> data = Cf.hashMap();
        data.put("requiredProp1", DataField.string("requiredProp1Value"));
        data.put("requiredProp2", DataField.string("requiredProp2Value"));

        TypeSettings ts = getTypeSettings(jsonSchema);
        validator.handleGenericObjectRecordChanged(Option.empty(), getDataRecord(data), ts);
    }

}
