package ru.yandex.chemodan.app.dataapi.core.generic;

import ru.yandex.chemodan.app.dataapi.utils.HttpStatusCodeSourceWithErrorLevel;
import ru.yandex.chemodan.util.exception.A3ExceptionWithStatus;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author Denis Bakharev
 */
public class InvalidInputException extends A3ExceptionWithStatus implements HttpStatusCodeSourceWithErrorLevel {

    public InvalidInputException(String message, Throwable cause) {
        super(ru.yandex.chemodan.util.web.ErrorNames.BAD_REQUEST, message, cause, HttpStatus.SC_400_BAD_REQUEST);
    }

    public InvalidInputException(String message) {
        super(ru.yandex.chemodan.util.web.ErrorNames.BAD_REQUEST, message, HttpStatus.SC_400_BAD_REQUEST);
    }
}
