package ru.yandex.chemodan.app.dataapi.core.generic;

import ru.yandex.chemodan.util.exception.A3ExceptionWithStatus;
import ru.yandex.commune.a3.action.result.error.ErrorLogLevelSource;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.log.mlf.Level;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class RequiredParamNotSpecifiedException extends A3ExceptionWithStatus implements ErrorLogLevelSource {
    public RequiredParamNotSpecifiedException(String paramName) {
        super(String.format("%s not specified", paramName), HttpStatus.SC_400_BAD_REQUEST);
    }

    @Override
    public Level getErrorLogLevel() {
        return Level.WARN;
    }
}
