package ru.yandex.chemodan.app.dataapi.core.generic;

import org.joda.time.Instant;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.core.generic.bazinga.GenericObjectDeletionTask;
import ru.yandex.chemodan.app.dataapi.test.UnitTestBase;
import ru.yandex.commune.bazinga.test.BazingaTaskManagerStub;
import ru.yandex.misc.test.Assert;

import static org.mockito.Mockito.mock;

/**
 * @author Denis Bakharev
 */
public class ScheduleObjectDeletionHandlerTest extends UnitTestBase {
    private final BazingaTaskManagerStub bazingaStub = new BazingaTaskManagerStub();
    private final ScheduleObjectDeletionHandler handler =
            new ScheduleObjectDeletionHandler(bazingaStub, mock(TypeSettingsRegistry.class));
    private final Instant now = Instant.now();

    @Test
    public void handleGenericObjectRecordChanged_NewRecordWithDeletionDate_ScheduleDeletion() {

        handler.handleGenericObjectRecordChanged(Option.empty(), getDataRecord(getDataWithDate(now)), getTypeSettings());
        assertScheduleDeletionTask();
    }

    @Test
    public void handleGenericObjectRecordChanged_NewRecordWithoutDeletionDate_DoesNotScheduleDeletion() {

        handler.handleGenericObjectRecordChanged(Option.empty(), getDataRecord(Cf.hashMap()), getTypeSettings());
        Assert.isEmpty(bazingaStub.tasksWithParams);
    }

    @Test
    public void handleGenericObjectRecordChanged_OldRecordHasSameDeletionDate_DoesNotScheduleDeletion() {
        handler.handleGenericObjectRecordChanged(
                Option.of(getDataRecord(getDataWithDate(now))),
                getDataRecord(getDataWithDate(now)),
                getTypeSettings());

        Assert.isEmpty(bazingaStub.tasksWithParams);
    }

    @Test
    public void handleGenericObjectRecordChanged_NewRecordHasUpdatedDeletionDate_ScheduleDeletion() {
        handler.handleGenericObjectRecordChanged(
                Option.of(getDataRecord(getDataWithDate(now.plus(100)))),
                getDataRecord(getDataWithDate(now)),
                getTypeSettings());

        assertScheduleDeletionTask();
    }

    private void assertScheduleDeletionTask() {
        Assert.isInstance(bazingaStub.tasksWithParams.get(0), GenericObjectDeletionTask.class);
    }

    private MapF<String, DataField> getDataWithDate(Instant date) {
        MapF<String, DataField> data = Cf.hashMap();
        data.put("date", DataField.timestamp(date));
        return data;
    }
}
