package ru.yandex.chemodan.app.dataapi.core.generic;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.record.CollectionRef;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRefSource;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Denis Bakharev
 */
@BenderBindAllFields
public class TypeLocation extends DefaultObject {
    public final Option<String> app;
    public final String databaseId;
    public final String collectionId;

    public TypeLocation(DatabaseRefSource dbRefSrc, String collectionId) {
        this(dbRefSrc.appNameO(), dbRefSrc.databaseId(), collectionId);
    }

    public TypeLocation(Option<String> app, String databaseId, String collectionId) {
        this.app = app;
        this.databaseId = databaseId;
        this.collectionId = collectionId;
    }

    public DatabaseRef dbRef() {
        return DatabaseRef.cons(app, databaseId);
    }

    public CollectionRef toColRef() {
        return CollectionRef.cons(dbRef(), collectionId);
    }
}
