package ru.yandex.chemodan.app.dataapi.core.generic;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.record.CollectionRef;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.core.generic.filter.Order;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderDefaultValue;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Denis Bakharev
 */
@BenderBindAllFields
public class TypeSettings extends DefaultObject {
    public final String typeName;
    public final String jsonSchema;
    public final String idPropertyName;
    public final Option<Boolean> orderedId;
    public final boolean isAllowInsert;
    public final boolean isAllowSet;
    public final ListF<Order> allowedOrders;
    public final TypeLocation typeLocation;
    public final Option<DeletionSettings> deletionSettings;
    public final Option<String> description;
    @BenderDefaultValue("false")
    public final boolean isDryRun;

    public TypeSettings(
            String jsonSchema,
            String typeName,
            String idPropertyName,
            boolean isAllowInsert,
            boolean isAllowSet,
            ListF<Order> allowedOrders,
            TypeLocation typeLocation,
            Option<DeletionSettings> deletionSettings,
            boolean isDryRun)
    {
        this(jsonSchema, typeName, idPropertyName, false,
                isAllowInsert, isAllowSet, allowedOrders, typeLocation, deletionSettings, Option.empty(), isDryRun);
    }

    public TypeSettings(
            String jsonSchema,
            String typeName,
            String idPropertyName,
            boolean orderedId,
            boolean isAllowInsert,
            boolean isAllowSet,
            ListF<Order> allowedOrders,
            TypeLocation typeLocation,
            Option<DeletionSettings> deletionSettings,
            Option<String> description,
            boolean isDryRun)
    {
        this.jsonSchema = jsonSchema;
        this.typeName = typeName;
        this.idPropertyName = idPropertyName;
        this.orderedId = Option.of(orderedId);
        this.isAllowInsert = isAllowInsert;
        this.isAllowSet = isAllowSet;
        this.allowedOrders = allowedOrders;
        this.typeLocation = typeLocation;
        this.deletionSettings = deletionSettings;
        this.description = description;
        this.isDryRun = isDryRun;
    }

    public DatabaseRef dbRef() {
        return typeLocation.dbRef();
    }

    public CollectionRef toColRef() {
        return typeLocation.toColRef();
    }

    public TypeSettings withTypeLocation(TypeLocation typeLocation) {
        return new TypeSettings(
                jsonSchema, typeName, idPropertyName, orderedId.isSome(true),
                isAllowInsert, isAllowSet, allowedOrders, typeLocation, deletionSettings, description, isDryRun);
    }
}
