package ru.yandex.chemodan.app.dataapi.core.generic;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.record.CollectionRef;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.utils.DataApiZkRegistry;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkPathEscaping;
import ru.yandex.misc.lang.Check;

/**
 * @author Denis Bakharev
 */
public class TypeSettingsRegistry extends DataApiZkRegistry<TypeSettings> {
    private volatile TypeSettingsRegistryState state;

    public TypeSettingsRegistry(ZkPath zkPath) {
        super(zkPath, TypeSettings.class, s -> s.typeName, ZkPathEscaping.urlEncode);
    }

    private TypeSettingsRegistryState state() {
        Check.notNull(state, "Not initialized");
        return state;
    }

    public void setTypeSettings(TypeSettings typeSettings) {
        put(typeSettings);
    }

    public void deleteTypeSettings(String typeName) {
        remove(typeName);
    }

    public ListF<TypeSettings> getAllTypeSettings() {
        return state().allSettings;
    }

    public TypeSettings getTypeSettings(String typeName) {
        return state().typeNameToSettingsMap.getO(typeName).getOrThrow(() -> new UnknownTypeNameException(typeName));
    }

    public Option<TypeSettings> getTypeSettingsO(String typeName) {
        return state().typeNameToSettingsMap.getO(typeName);
    }

    public Option<TypeSettings> getTypeSettings(TypeLocation typeLocation) {
        return state().typeLocationToSettingsMap.getO(typeLocation);
    }

    @Override
    protected void handleNewState(CollectionF<TypeSettings> allElements) {
        state = new TypeSettingsRegistryState(allElements);
    }

    public boolean hasSettings(DatabaseRef ref) {
        return state().hasSettings(ref);
    }

    public boolean hasSettings(CollectionRef ref) {
        return state().hasSettings(ref);
    }
}
