package ru.yandex.chemodan.app.dataapi.core.generic;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;

/**
 * @author yashunsky
 */

@Configuration
public class TypeSettingsRegistryContextConfiguration {
    @Bean
    public TypeSettingsRegistry typeSettingsRegistry(
            @Qualifier("zkRoot") ZkPath zkRoot, ZkManager zkManager)
    {
        TypeSettingsRegistry typeSettingsRegistry = new TypeSettingsRegistry(zkRoot.child("generic-data-types"));
        zkManager.addClient(typeSettingsRegistry);
        return typeSettingsRegistry;
    }
}
