package ru.yandex.chemodan.app.dataapi.core.generic;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.dataapi.api.data.record.CollectionRef;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;

/**
 * @author Denis Bakharev
 */
public class TypeSettingsRegistryState {
    public final MapF<String, TypeSettings> typeNameToSettingsMap;
    public final ListF<TypeSettings> allSettings;
    public final MapF<TypeLocation, TypeSettings> typeLocationToSettingsMap;
    private final SetF<DatabaseRef> appDbRefs;

    public TypeSettingsRegistryState(CollectionF<TypeSettings> settings) {
        typeNameToSettingsMap = Cf.hashMap(settings.toMapMappingToKey(ts -> ts.typeName));
        allSettings = Cf.list(typeNameToSettingsMap.values());
        typeLocationToSettingsMap = Cf.hashMap(allSettings.toMapMappingToKey(ts -> ts.typeLocation));
        appDbRefs = allSettings
                .map(TypeSettings::dbRef)
                .unique();
    }

    public TypeSettingsRegistryState plus(TypeSettings newSettings) {
        return new TypeSettingsRegistryState(allSettings.plus(newSettings));
    }

    public TypeSettingsRegistryState minus(String typeName) {
        return new TypeSettingsRegistryState(
                allSettings.filter(ts -> !ts.typeName.equals(typeName)));
    }

    boolean hasSettings(DatabaseRef ref) {
        return appDbRefs.containsTs(ref);
    }

    public boolean hasSettings(CollectionRef colRef) {
        return typeLocationToSettingsMap.keySet().containsTs(colRef.toTypeLocation());
    }
}
