package ru.yandex.chemodan.app.dataapi.core.generic;

import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.core.dao.test.ActivateDataApiEmbeddedPg;
import ru.yandex.chemodan.app.dataapi.test.DataApiTestSupport;
import ru.yandex.commune.util.RetryUtils;
import ru.yandex.misc.test.Assert;

/**
 * @author Denis Bakharev
 */
@ActivateDataApiEmbeddedPg
public class TypeSettingsRegistryTest extends DataApiTestSupport {

    @Autowired
    TypeSettingsRegistry typeSettingsRegistry;

    @Before
    public void before() {
        typeSettingsRegistry.removeAll();
    }

    @Test
    public void simpleTypeSettingsTest() throws Exception {
        String schema =
                "{\n"
                + "  \"type\": \"object\",\n"
                + "  \"properties\": {\n"
                + "    \"key\": {\n"
                + "      \"type\": \"string\"\n"
                + "    },\n"
                + "    \"prop2\": {\n"
                + "      \"type\": \"string\"\n"
                + "    }\n"
                + "  }\n"
                + "}";

        TypeLocation typeLocation = new TypeLocation(Option.empty(), "myTypeCollectionId", "myTypeDatabaseId");
        TypeSettings ts = new TypeSettings(
                schema, "myTypeName", "key", true, true, Cf.list(), typeLocation, Option.empty(), false);

        typeSettingsRegistry.setTypeSettings(ts);
        RetryUtils.retry(2, 50, 0.5f, () -> {
            TypeSettings loadedTs = typeSettingsRegistry.getTypeSettings("myTypeName");
            Assert.equals(ts, loadedTs);
            return true;
        });

    }
}
