package ru.yandex.chemodan.app.dataapi.core.generic;

import ru.yandex.chemodan.app.dataapi.ErrorNames;
import ru.yandex.chemodan.app.dataapi.utils.HttpStatusCodeSourceWithErrorLevel;
import ru.yandex.chemodan.util.exception.A3ExceptionWithStatus;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author Denis Bakharev
 */
public class UnknownTypeNameException extends A3ExceptionWithStatus implements HttpStatusCodeSourceWithErrorLevel {
    public UnknownTypeNameException(String typeName) {
        super(
                ErrorNames.UNKNOWN_GENERIC_OBJECT_TYPE_NAME,
                "Unknown type name = " + typeName,
                HttpStatus.SC_400_BAD_REQUEST);
    }
}
