package ru.yandex.chemodan.app.dataapi.core.generic.bazinga;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.core.generic.GenericObjectManager;
import ru.yandex.chemodan.app.dataapi.worker.DataApiTaskQueueName;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;

/**
 * @author Denis Bakharev
 */
public class GenericObjectDeletionTask extends OnetimeTaskSupport<GenericObjectDeletionTaskParams> {

    private final GenericObjectManager genericObjectManager;

    public GenericObjectDeletionTask(DataApiUserId uid, String typeName, String recordId) {
        super(new GenericObjectDeletionTaskParams(uid, typeName, recordId));
        genericObjectManager = null;
    }

    public GenericObjectDeletionTask(GenericObjectManager genericObjectManager) {
        super(GenericObjectDeletionTaskParams.class);

        this.genericObjectManager = genericObjectManager;
    }

    @Override
    protected void execute(
            GenericObjectDeletionTaskParams params, ExecutionContext context) throws Exception
    {
        genericObjectManager.deleteByDeletionDate(params.uid, params.recordId, params.typeName);
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(5);
    }

    @Override
    public TaskQueueName queueName() {
        return DataApiTaskQueueName.DATAAPI_REGULAR;
    }
}
