package ru.yandex.chemodan.app.dataapi.core.generic.filter;

import org.jparsec.Parser;
import org.jparsec.Scanners;
import org.jparsec.Terminals;
import org.jparsec.error.ParserException;

import ru.yandex.chemodan.app.dataapi.api.data.filter.condition.RecordCondition;

/**
 * @author dbrylev
 */
public class ConditionParser {

    static final Terminals terminals = Terminals
            .operators("(", ")", "=", "!=", ">", ">=", "<", "<=", ",")
            .words(Scanners.IDENTIFIER)
            .caseInsensitiveKeywords("and", "or", "not", "between", "in", "is", "true", "false", "null")
            .build();

    static final Parser<? extends Condition> parser = Condition.parser()
            .from(Condition.tokenizer(), Scanners.WHITESPACES.skipMany());

    public static Condition parse(String expression) {
        try {
            return parser.parse(expression);

        } catch (ParserException e) {
            throw new FilterBuildingException(e);
        }
    }

    public static RecordCondition parse(String expression, FilterBuildingContext context) {
        return parse(expression).buildCondition(context);
    }
}
