package ru.yandex.chemodan.app.dataapi.core.generic.filter;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.jparsec.Parser;
import org.jparsec.Terminals;

import ru.yandex.chemodan.app.dataapi.api.data.filter.condition.ConvertingRecordColumn;
import ru.yandex.chemodan.app.dataapi.api.data.filter.condition.DataColumn;
import ru.yandex.chemodan.app.dataapi.api.data.filter.condition.RecordIdColumn;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.typeconverters.BooleanTypeConverter;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.typeconverters.IntegerTypeConverter;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.typeconverters.NumberTypeConverter;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.typeconverters.StringTypeConverter;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.typeconverters.TimestampTypeConverter;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.typeconverters.TypeConverter;

/**
 * @author dbrylev
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class Field extends Operand {

    private final String name;

    public static Parser<?> tokenizer() {
        return Terminals.Identifier.TOKENIZER;
    }

    public static Parser<Field> parser() {
        return Terminals.Identifier.PARSER.map(Field::new);
    }

    @Override
    public String valueString() {
        return "field " + name;
    }

    public ConvertingRecordColumn<Value> getColumn(FilterBuildingContext context) {
        TypeConverter converter = context.getFieldTypeConverter(this);

        if (converter instanceof IntegerTypeConverter) {
            return new ConvertingRecordColumn<>(DataColumn.integer(name), ValueConverter.integer(context)::convert);
        }

        if (converter instanceof NumberTypeConverter) {
            return new ConvertingRecordColumn<>(DataColumn.decimal(name), ValueConverter.decimal(context)::convert);
        }

        if (converter instanceof BooleanTypeConverter) {
            return new ConvertingRecordColumn<>(DataColumn.bool(name), ValueConverter.bool(context)::convert);
        }

        if (converter instanceof StringTypeConverter) {
            return context.getTypeSettings().idPropertyName.equals(name)
                    ? new ConvertingRecordColumn<>(RecordIdColumn.C, ValueConverter.string(context)::convert)
                    : new ConvertingRecordColumn<>(DataColumn.string(name), ValueConverter.string(context)::convert);
        }

        if (converter instanceof TimestampTypeConverter) {
            return new ConvertingRecordColumn<>(DataColumn.timestamp(name), ValueConverter.timestamp(context)::convert);
        }

        throw new FilterBuildingException("Field " + name
                + " is of unsupported type " + converter.getConvertedTypeName());
    }
}
