package ru.yandex.chemodan.app.dataapi.core.generic.filter;

import lombok.Data;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.core.generic.TypeSettings;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.FormatConverter;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.typeconverters.TypeConverter;

/**
 * @author dbrylev
 */
@Data
public class FilterBuildingContext {

    private final TypeSettings typeSettings;
    private final FormatConverter formatConverter;
    private final Option<MapF<String, DataField>> recordData;


    public TypeConverter getFieldTypeConverter(Field field) {
        return formatConverter.getFieldConverter(field.getName()).getOrThrow(
                () -> new FilterBuildingException("No such field defined " + field.getName()));
    }

    public DataField getPlaceholderDataField(Value.Placeholder placeholder) {
        String field = placeholder.getField();

        return recordData
                .getOrThrow(() -> new FilterBuildingException("Placeholders are unavailable in current context"))
                .getO(field).getOrThrow(() -> new FilterBuildingException("No data for placeholder " + field));
    }

    public boolean isAllowedOrder(Order order) {
        if (order.getComponents().isEmpty()) return true;

        ListF<Order> orders = typeSettings.allowedOrders
                .plus(OrderedUuidField.F.orderBy(true))
                .plus(new Order(Cf.list(new Order.Component(new Field(typeSettings.idPropertyName), true))));

        return orders.iterator().plus(orders.iterator().map(Order::reversed)).exists(order::startsWith);
    }

    public void ensureIsAllowedOrder(Order order) {
        if (!isAllowedOrder(order)) {
            throw new FilterBuildingException("Not allowed to use order: " + order.benderSerialize());
        }
    }
}
