package ru.yandex.chemodan.app.dataapi.core.generic.filter;

import org.junit.Test;
import org.mockito.Mockito;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.core.generic.TypeLocation;
import ru.yandex.chemodan.app.dataapi.core.generic.TypeSettings;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.FormatConverter;
import ru.yandex.misc.test.Assert;

/**
 * @author dbrylev
 */
public class FilterBuildingContextTest {

    @Test
    public void allowedOrder() {
        FilterBuildingContext empty = context(Cf.list());
        FilterBuildingContext any = context(Cf.list(Order.benderParse("*")));
        FilterBuildingContext fields = context(Cf.list(OrderParser.parse("f1, -f2")));

        Assert.isTrue(empty.isAllowedOrder(Order.empty()));
        Assert.isTrue(fields.isAllowedOrder(Order.empty()));

        Assert.isTrue(empty.isAllowedOrder(OrderedUuidField.F.orderBy(false)));
        Assert.isTrue(fields.isAllowedOrder(OrderedUuidField.F.orderBy(false)));

        Assert.isTrue(isAllowed(empty, "id"));
        Assert.isTrue(isAllowed(empty, "-id"));

        Assert.isFalse(isAllowed(empty, "f1"));
        Assert.isTrue(isAllowed(any, "f1"));

        Assert.isFalse(isAllowed(fields, "f1"));
        Assert.isFalse(isAllowed(fields, "f1, f2"));

        Assert.isTrue(isAllowed(fields, "f1, -f2"));
        Assert.isTrue(isAllowed(fields, "-f1, f2"));
        Assert.isTrue(isAllowed(fields, "-f1, f2, f3"));
    }

    private static boolean isAllowed(FilterBuildingContext context, String order) {
        return context.isAllowedOrder(OrderParser.parse(order));
    }

    private static FilterBuildingContext context(ListF<Order> allowedOrders) {
        return new FilterBuildingContext(settings(allowedOrders), Mockito.mock(FormatConverter.class), Option.empty());
    }

    private static TypeSettings settings(ListF<Order> allowedOrders) {
        return new TypeSettings(
                "", "", "id", false, false,
                allowedOrders, Mockito.mock(TypeLocation.class), Option.empty(), false);
    }

}
