package ru.yandex.chemodan.app.dataapi.core.generic.filter;

import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.core.generic.loader.DataRecordsFilter;
import ru.yandex.misc.db.q.SqlLimits;

/**
 * @author dbrylev
 */
@Data
public class ObjectsFilter {
    private final Condition condition;
    private final Order order;
    private final SqlLimits limits;


    public DataRecordsFilter buildFilter(FilterBuildingContext context) {
        context.ensureIsAllowedOrder(order);

        return new DataRecordsFilter(
                condition.buildCondition(context),
                Option.when(order.isNotEmpty(), () -> order.buildOrder(context)),
                limits, isTotalCountNeeded());
    }

    public static ObjectsFilter all() {
        return new ObjectsFilter(Condition.trueCondition(), Order.empty(), SqlLimits.all());
    }

    public ObjectsFilter withLimits(SqlLimits limits) {
        return new ObjectsFilter(condition, order, limits);
    }

    public boolean isTotalCountNeeded() {
        boolean isTrue = condition instanceof Condition.True;

        boolean isOrderedUuid = condition instanceof Predicate
                && ((Predicate) condition).getField() instanceof OrderedUuidField;

        return !limits.isAll() && (isTrue || isOrderedUuid);
    }
}
