package ru.yandex.chemodan.app.dataapi.core.generic.filter;

import org.jparsec.Parser;
import org.jparsec.Scanners;
import org.jparsec.Terminals;
import org.jparsec.error.ParserException;

import ru.yandex.chemodan.app.dataapi.api.data.filter.ordering.ByDataRecordOrder;

/**
 * @author dbrylev
 */
public class OrderParser {

    static final Terminals terminals = Terminals.operators("+", "-", ",");

    static final Parser<Order> parser = Order.parser()
            .from(Order.tokenizer(), Scanners.WHITESPACES.skipMany());

    public static Order parse(String expression) {
        try {
            return parser.parse(expression);

        } catch (ParserException e) {
            throw new FilterBuildingException(e);
        }
    }

    public static ByDataRecordOrder parse(String expression, FilterBuildingContext context) {
        return parse(expression).buildOrder(context);
    }
}
