package ru.yandex.chemodan.app.dataapi.core.generic.filter;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.filter.condition.ConvertingRecordColumn;
import ru.yandex.chemodan.app.dataapi.api.data.filter.condition.RecordIdColumn;
import ru.yandex.chemodan.app.dataapi.api.data.filter.ordering.OrderedUUID;

/**
 * @author dbrylev
 */
public class OrderedUuidField extends Field {

    public static final OrderedUuidField F = new OrderedUuidField();

    private OrderedUuidField() {
        super("$id");
    }

    public Order orderBy(boolean asc) {
        return new Order(Cf.list(new Order.Component(this, asc)));
    }

    public Condition between(Option<String> min, Option<String> max) {
        return new Predicate.Between(this,
                new Value.Text(min.getOrElse(OrderedUUID.MIN_FROM)),
                new Value.Text(max.getOrElse(OrderedUUID.MAX_TO)), true);
    }

    @Override
    public ConvertingRecordColumn<Value> getColumn(FilterBuildingContext context) {
        return new ConvertingRecordColumn<>(RecordIdColumn.C, ValueConverter.string(context)::convert);
    }
}
