package ru.yandex.chemodan.app.dataapi.core.generic.loader;

import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.filter.RecordsFilter;
import ru.yandex.chemodan.app.dataapi.api.data.filter.condition.RecordCondition;
import ru.yandex.chemodan.app.dataapi.api.data.filter.ordering.ByDataRecordOrder;
import ru.yandex.chemodan.app.dataapi.api.data.record.CollectionRef;
import ru.yandex.misc.db.q.SqlLimits;

/**
 * @author dbrylev
 */
@Data
public class DataRecordsFilter {
    private final RecordCondition condition;
    private final Option<ByDataRecordOrder> order;
    private final SqlLimits limits;
    private final boolean totalCountNeeded;


    public static DataRecordsFilter all() {
        return new DataRecordsFilter(RecordCondition.all(), Option.empty(), SqlLimits.all(), false);
    }

    public static DataRecordsFilter limited(SqlLimits limits) {
        return new DataRecordsFilter(RecordCondition.all(), Option.empty(), limits, !limits.isAll());
    }

    public DataRecordsFilter withoutTotalCount() {
        return new DataRecordsFilter(condition, order, limits, false);
    }

    public RecordsFilter toRecordsFilter(CollectionRef collection) {
        return RecordsFilter.DEFAULT
                .withColRef(collection)
                .withRecordCond(condition)
                .withRecordOrderO(order)
                .withLimits(limits);
    }
}
