package ru.yandex.chemodan.app.dataapi.core.generic.loader;

import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.db.ref.AppDatabaseRef;
import ru.yandex.chemodan.app.dataapi.apps.settings.AppDatabaseSettings;
import ru.yandex.chemodan.app.dataapi.apps.settings.AppSettingsRegistry;
import ru.yandex.chemodan.app.dataapi.core.generic.LimitedResult;
import ru.yandex.chemodan.app.dataapi.core.generic.TypeLocation;
import ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata.AppDataLoader;
import ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata.model.AppId;
import ru.yandex.chemodan.app.dataapi.test.TestDataGenerator;
import ru.yandex.chemodan.app.dataapi.test.UnitTestBase;
import ru.yandex.misc.test.Assert;

import static org.mockito.Mockito.eq;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verifyNoMoreInteractions;
import static org.mockito.Mockito.when;

/**
 * @author Denis Bakharev
 */
public class DataRecordsFromAppDataLoaderUnitTest extends UnitTestBase {
    @Test
    public void getRecordsTest() {
        AppId appId = TestDataGenerator.getAppId();
        AppDataLoader dataLoaderMock = mock(AppDataLoader.class);
        when(dataLoaderMock.loadAppData(eq(appId))).thenReturn(
                Option.of(TestDataGenerator.getAppData(appId)));

        AppDatabaseRef dbRef = new AppDatabaseRef(appId.getAppName().get(), "dbId");
        TypeLocation tl = new TypeLocation(dbRef, "colId");

        AppSettingsRegistry cacheSettingsMock = mock(AppSettingsRegistry.class);
        when(cacheSettingsMock.getDatabaseSettings(eq(dbRef)))
                .thenReturn(new AppDatabaseSettings(dbRef).enableCaching());

        DataRecordsLoader downstreamLoaderMock = mock(DataRecordsLoader.class);
        DataRecordsFromAppDataLoader recordsLoader =
                new DataRecordsFromAppDataLoader(dataLoaderMock, cacheSettingsMock, downstreamLoaderMock);

        LimitedResult<DataRecord> records = recordsLoader.getRecords(appId.getUid(), tl, DataRecordsFilter.all());

        Assert.none(records.totalCount);
        Assert.sizeIs(1, records.result);

        verifyNoMoreInteractions(downstreamLoaderMock);
    }
}
