package ru.yandex.chemodan.app.dataapi.core.generic.loader;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;

import ru.yandex.chemodan.app.dataapi.apps.settings.AppSettingsRegistry;
import ru.yandex.chemodan.app.dataapi.core.dao.support.ShardedTransactionManager;
import ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata.AppDataLoader;
import ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata.AppDataStorageContextConfiguration;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;

/**
 * @author Denis Bakharev
 */
@Profile("dataapi")
@Configuration
@Import({AppDataStorageContextConfiguration.class})
public class DataRecordsLoaderContextConfiguration {
    @Bean
    public DataRecordsLoader dataRecordsLoader(
            DataApiManager dataApiManager,
            ShardedTransactionManager transactionManager,
            AppDataLoader appDataLoader,
            AppSettingsRegistry appSettingsRegistry)
    {
        return new DataRecordsFromAppDataLoader(
                appDataLoader,
                appSettingsRegistry,
                new DataRecordsFromDatabaseLoader(dataApiManager, transactionManager));
    }
}
