package ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata.model.AppData;
import ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata.model.AppId;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Denis Bakharev
 */
public class AppDataLoader {
    private final Logger logger = LoggerFactory.getLogger(getClass());
    private final ListF<AppDataStorage> storages;

    public AppDataLoader(ListF<AppDataStorage> storages) {
        this.storages = storages;
    }

    public Option<AppData> loadAppData(AppId appId) {
        Option<AppData> result = searchForAppDataIterativelyAndFillEmptyStoragesIfFound(appId);
        return result;
    }

    private Option<AppData> searchForAppDataIterativelyAndFillEmptyStoragesIfFound(AppId appId) {
        Option<AppData> result = Option.empty();
        for (int i = 0; i < storages.length(); i++) {
            AppDataStorage storage = storages.get(i);
            result = storage.find(appId);
            if (result.isPresent()) {
                logger.debug(
                        "Found AppData with {} in storage {}", appId.toString(), storage.getClass().getSimpleName());

                setAppDataToEmptyStorages(result.get(), i);
                break;
            }

            logger.debug(
                    "Not fount AppData with {} in storage {}", appId.toString(), storage.getClass().getSimpleName());
        }
        return result;
    }

    private void setAppDataToEmptyStorages(AppData appData, int sourceAppDataStorage) {
        for (int i = 0; i < sourceAppDataStorage; i++) {
            AppDataStorage storage = storages.get(i);
            logger.debug(
                    "Set new AppData with {} to storage {}", appData.getId(), storage.getClass().getSimpleName());
            storage.set(appData);
        }
    }
}
