package ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata.model.AppData;
import ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata.model.AppId;
import ru.yandex.chemodan.app.dataapi.test.TestDataGenerator;
import ru.yandex.chemodan.app.dataapi.test.UnitTestBase;
import ru.yandex.misc.test.Assert;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verifyNoMoreInteractions;
/**
 * @author Denis Bakharev
 */
public class AppDataLoaderUnitTest extends UnitTestBase {
    private AppId appId = new AppId(getUserId(), Option.of("app"));

    @Test
    public void loadAppData_AppDataExistOnlyInSecond_LoadFromSecondAndSetAppDataToFirst() {
        SimpleDataStorage first = new SimpleDataStorage();
        SimpleDataStorage second = new SimpleDataStorage();

        second.set(TestDataGenerator.getAppData(appId));
        AppDataStorage doNotInvokeMe = mock(AppDataStorage.class);

        AppDataLoader loader = new AppDataLoader(Cf.list(first, second, doNotInvokeMe));
        Option<AppData> appDataO = loader.loadAppData(appId);
        Assert.notEmpty(appDataO);

        Assert.equals(appDataO.get(), second.find(appId).get());
        Assert.equals(appDataO.get(), first.find(appId).get());

        verifyNoMoreInteractions(doNotInvokeMe);
    }

    private static class SimpleDataStorage implements AppDataStorage {
        private Option<AppData> appDataO = Option.empty();
        @Override
        public Option<AppData> find(AppId appId) {
            return appDataO.filter(appData -> appData.getId().equals(appId));
        }

        @Override
        public void set(AppData appData) {
            this.appDataO = Option.of(appData);
        }
    }
}
