package ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.dataapi.apps.settings.AppSettingsRegistry;
import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;

/**
 * @author Denis Bakharev
 */
@Configuration
public class AppDataStorageContextConfiguration {
    @Bean
    public AppDataLoader appDataLoader(
            ThreadLocalAppDataStorage threadLocalAppDataStorage,
            DatabaseAppDataStorage databaseAppDataStorage)
    {
        return new AppDataLoader(Cf.list(threadLocalAppDataStorage, databaseAppDataStorage));
    }

    @Bean
    public DatabaseAppDataStorage databaseAppDataStorage(
            DiskDataSource dataApiManager, AppSettingsRegistry appSettingsRegistry)
    {
        return new DatabaseAppDataStorage(dataApiManager, appSettingsRegistry);
    }

    @Bean
    public ThreadLocalAppDataStorage threadLocalAppDataStorage() {
        return new ThreadLocalAppDataStorage();
    }
}
