package ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.apps.settings.AppSettings;
import ru.yandex.chemodan.app.dataapi.apps.settings.AppSettingsRegistry;
import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata.model.AppCollectionData;
import ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata.model.AppData;
import ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata.model.AppDatabaseData;
import ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata.model.AppId;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Denis Bakharev
 */
public class DatabaseAppDataStorage implements AppDataStorage {
    private final Logger logger = LoggerFactory.getLogger(getClass());
    private final DiskDataSource dataApiManager;
    private final AppSettingsRegistry appSettingsRegistry;

    public DatabaseAppDataStorage(DiskDataSource dataApiManager, AppSettingsRegistry appSettingsRegistry) {
        this.dataApiManager = dataApiManager;
        this.appSettingsRegistry = appSettingsRegistry;
    }

    @Override
    public Option<AppData> find(AppId appId) {
        AppSettings settings = appSettingsRegistry.getSettings(appId.getAppName());

        if (settings.isEmpty()) {
            logger.info("Can not load AppData for {} because cache settings does not exist", appId);
            return Option.empty();
        }

        ListF<DataRecord> dbRecords = dataApiManager.getDataRecords(appId.getUid(), settings.getDatabasesFilter());
        ListF<AppDatabaseData> databaseDatas = dbRecords.groupBy(r -> r.id.handle)
                .mapEntries(
                        (handle, groupRecs) -> new AppDatabaseData(
                                handle,
                                groupRecs.groupBy(DataRecord::getCollectionId)
                                        .mapEntries(AppCollectionData::cons))
                );

        return Option.of(new AppData(appId, databaseDatas));
    }

    @Override
    public void set(AppData appData) {
        throw new UnsupportedOperationException();
    }
}
