package ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata;

import net.spy.memcached.MemcachedClient;

import ru.yandex.chemodan.app.dataapi.api.DatabaseChangedEventAsyncHandler;
import ru.yandex.chemodan.app.dataapi.api.deltas.DatabaseChange;
import ru.yandex.chemodan.app.dataapi.apps.settings.AppSettingsRegistry;
import ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata.model.AppId;
import ru.yandex.chemodan.app.dataapi.utils.memcached.MemcachedClients;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Denis Bakharev
 */
public class MemcachedAppDataInvalidator implements DatabaseChangedEventAsyncHandler {
    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final MemcachedClients memcachedClients;
    private final AppSettingsRegistry appSettingsRegistry;

    public MemcachedAppDataInvalidator(
            MemcachedClients memcachedClients, AppSettingsRegistry appSettingsRegistry)
    {
        this.memcachedClients = memcachedClients;
        this.appSettingsRegistry = appSettingsRegistry;
    }

    @Override
    public void databaseChanged(DatabaseChange databaseChange) {
        if (appSettingsRegistry.getDatabaseSettings(databaseChange.patchedDatabase()).isUseCache()) {
            AppId appId = new AppId(databaseChange.patchedDatabase());
            logger.info("Invalidating cache for AppData with {}", appId);
            for (MemcachedClient memcachedClient : memcachedClients.allClients) {
                try {
                    memcachedClient.delete(appId.toString());
                } catch (Exception e) {
                    logger.error("Failed to remove AppData with {} from cache: {}", appId, e);
                }
            }
        }
    }
}
