package ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata.model.AppData;
import ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata.model.AppId;
import ru.yandex.misc.cache.Cache;
import ru.yandex.misc.cache.tl.TlCache;

/**
 * @author Denis Bakharev
 */
public class ThreadLocalAppDataStorage implements AppDataStorage {

    private final Cache<AppId, AppData> localCache =
            TlCache.asCache(ThreadLocalAppDataStorage.class.getName() + ".local");

    public Option<AppData> find(AppId appId) {
        return Option.x(localCache.getFromCache(appId));
    }

    public void set(AppData appData) {
        localCache.putInCache(appData.getId(), appData);
    }
}
