package ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata;

import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata.model.AppData;
import ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata.model.AppId;
import ru.yandex.chemodan.app.dataapi.test.TestDataGenerator;
import ru.yandex.chemodan.app.dataapi.test.UnitTestBase;
import ru.yandex.misc.cache.tl.TlCache;
import ru.yandex.misc.test.Assert;

/**
 * @author Denis Bakharev
 */
public class ThreadLocalAppDataStorageUnitTest extends UnitTestBase {
    @Test
    public void simpleGetSetTest() {
        AppId appId = new AppId(getUserId(), Option.of("app"));
        AppData appData = TestDataGenerator.getAppData(appId);
        ThreadLocalAppDataStorage threadLocalAppDataStorage = new ThreadLocalAppDataStorage();
        Assert.isEmpty(threadLocalAppDataStorage.find(appId));

        TlCache.Handle handle = TlCache.push();
        try {
            threadLocalAppDataStorage.set(appData);
            Assert.equals(appData, threadLocalAppDataStorage.find(appId).get());
        } finally {
            handle.pop();
        }
    }
}
