package ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata.model;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.commune.protobuf5.annotation.ProtoIgnoreField;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Denis Bakharev
 */
public class AppCollectionData extends DefaultObject {
    @ProtoField(n = 1)
    private final String collectionId;
    @ProtoField(n = 2)
    private final ListF<AppRecordData> records;

    @ProtoIgnoreField
    private MapF<String, AppRecordData> recordsMap;

    public AppCollectionData(String collectionId, ListF<DataRecord> records) {
        this.collectionId = collectionId;
        this.records = records.map(DataRecord::toAppRecordData);
    }

    public static AppCollectionData cons(String collectionId, ListF<DataRecord> records) {
        return new AppCollectionData(collectionId, records);
    }

    public String getCollectionId() {
        return collectionId;
    }

    public MapF<String, AppRecordData> getRecordsMap() {
        if (recordsMap == null) {
            recordsMap = records.toMapMappingToKey(AppRecordData::getRecordId);
        }
        return recordsMap;
    }
}
