package ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata.model;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.commune.protobuf5.annotation.ProtoIgnoreField;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Denis Bakharev
 */
public class AppData extends DefaultObject {
    @ProtoField(n = 1)
    private final AppId id;
    @ProtoField(n = 2)
    private final ListF<AppDatabaseData> databases;

    @ProtoIgnoreField
    private MapF<String, AppDatabaseData> databasesMap;

    public AppData(AppId id, ListF<AppDatabaseData> databases) {
        this.id = id;
        this.databases = databases;
    }

    public MapF<String, AppDatabaseData> getDatabasesMap() {
        if(databasesMap == null) {
            databasesMap = databases.toMapMappingToKey(AppDatabaseData::getDatabaseId);
        }
        return databasesMap;
    }

    public AppId getId() {
        return id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;

        AppData appData = (AppData) o;

        return id.equals(appData.id);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + id.hashCode();
        return result;
    }
}
