package ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata.model;

import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.test.TestDataGenerator;
import ru.yandex.chemodan.app.dataapi.test.UnitTestBase;
import ru.yandex.commune.protobuf5.Protobuf5Serializer;
import ru.yandex.misc.test.Assert;

/**
 * @author Denis Bakharev
 */
public class AppDataTest extends UnitTestBase {
    @Test
    public void serializationTest() {
        Protobuf5Serializer<AppData> serializer = Protobuf5Serializer.cons(AppData.class);
        AppData source = TestDataGenerator.getAppData(new AppId(getUserId(), Option.of("app")));

        byte[] bytes = serializer.serialize(source);

        AppData target = serializer.deserialize(bytes);
        Assert.equals(target, source);
    }
}
