package ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata.model;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.commune.protobuf5.annotation.ProtoIgnoreField;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Denis Bakharev
 */
public class AppDatabaseData extends DefaultObject {
    @ProtoField(n = 1)
    private final String databaseId;

    @ProtoField(n = 2)
    private final String databaseHandle;

    @ProtoField(n = 3)
    private final ListF<AppCollectionData> collections;

    @ProtoIgnoreField
    private MapF<String, AppCollectionData> collectionsMap;

    public AppDatabaseData(DatabaseHandle handle, ListF<AppCollectionData> collections) {
        this(handle.databaseId(), handle.handle, collections);
    }

    public AppDatabaseData(String databaseId, String databaseHandle, ListF<AppCollectionData> collections) {
        this.databaseId = databaseId;
        this.databaseHandle = databaseHandle;
        this.collections = collections;
    }

    public MapF<String, AppCollectionData> getCollectionsMap() {
        if(collectionsMap == null) {
            collectionsMap = collections.toMapMappingToKey(AppCollectionData::getCollectionId);
        }
        return collectionsMap;
    }

    public String getDatabaseHandle() {
        return databaseHandle;
    }

    public String getDatabaseId() {
        return databaseId;
    }
}
