package ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata.model;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.commune.protobuf5.annotation.ProtoIgnoreField;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Denis Bakharev
 */
public class AppId extends DefaultObject {
    @ProtoField(n = 1)
    private final String stringUid;
    @ProtoField(n = 2)
    private final Option<String> appName;
    @ProtoIgnoreField
    private transient DataApiUserId uid;

    public AppId(Database database) {
        this(database.uid, database.appNameO());
    }

    public AppId(DataApiUserId uid, Option<String> appName) {
        this.stringUid = uid.toString();
        this.appName = appName;
        this.uid = uid;
    }

    public Option<String> getAppName() {
        return appName;
    }

    public DataApiUserId getUid() {
        if (uid == null) {
            uid = DataApiUserId.parse(stringUid);
        }
        return uid;
    }

    @Override
    public String toString() {
        return "AppId{" +
               "uid='" + stringUid + '\'' +
               ", appName=" + appName +
               '}';
    }
}
