package ru.yandex.chemodan.app.dataapi.core.generic.loader.appdata.model;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.protobuf.ProtobufDataField;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.commune.protobuf5.annotation.ProtoIgnoreField;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Denis Bakharev
 */
public class AppRecordData extends DefaultObject {
    @ProtoField(n = 1)
    private final String recordId;

    @ProtoField(n = 2)
    private final long revision;

    @ProtoField(n = 3)
    private final ListF<ProtobufDataField> dataFields;

    @ProtoIgnoreField
    private MapF<String, DataField> dataFieldMap;

    public AppRecordData(String recordId, long revision, MapF<String, DataField> dataFields) {
        this.recordId = recordId;
        this.revision = revision;
        this.dataFields = dataFields.mapEntries(ProtobufDataField::new);
    }

    public MapF<String, DataField> getDataFieldMap() {
        if(dataFieldMap == null) {
            dataFieldMap = dataFields.toMap(df -> df.fieldId, ProtobufDataField::toDataField);
        }

        return dataFieldMap;
    }

    public String getRecordId() {
        return recordId;
    }

    public long getRevision() {
        return revision;
    }
}
