package ru.yandex.chemodan.app.dataapi.core.limiter;

import ru.yandex.chemodan.app.dataapi.utils.HttpStatusCodeSourceWithErrorLevel;
import ru.yandex.commune.a3.action.A3Exception;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.log.mlf.Level;

/**
 * @author tolmalev
 */
public class DatabaseSizeLimitException extends A3Exception implements HttpStatusCodeSourceWithErrorLevel {
    public DatabaseSizeLimitException() {
        super(ru.yandex.chemodan.util.web.ErrorNames.SIZE_LIMIT_REACHED, "Size limit reached");
    }

    @Override
    public int getHttpStatusCode() {
        return HttpStatus.SC_507_INSUFFICIENT_STORAGE;
    }

    public Level getErrorLogLevel() {
        return Level.WARN;
    }
}
