package ru.yandex.chemodan.app.dataapi.core.limiter;

import ru.yandex.chemodan.app.dataapi.ErrorNames;
import ru.yandex.commune.a3.action.A3Exception;
import ru.yandex.commune.a3.action.http.HttpStatusCodeSource;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author tolmalev
 */
public class DatabasesCountLimitException extends A3Exception implements HttpStatusCodeSource {
    public DatabasesCountLimitException() {
        super(ErrorNames.DATABASES_COUNT_LIMIT_REACHED, "Databases count limit reached");
    }

    @Override
    public int getHttpStatusCode() {
        return HttpStatus.SC_507_INSUFFICIENT_STORAGE;
    }
}
