package ru.yandex.chemodan.app.dataapi.core.limiter.access;

import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class AccesRateLimitsTest {

    @Test
    public void byClient() {
        AccessRateLimits limits = new AccessRateLimits(AccessRateLimits.Type.BY_CLIENT, "app", Option.empty(), 10);
        LimitingCountersValue counters;

        counters = new LimitingCountersValue(1, 2, 3, 4);
        limits.checkLimits(counters);

        counters = new LimitingCountersValue(1, 200, 3, 4);
        limits.checkLimits(counters);

        counters = new LimitingCountersValue(10, 2, 3, 4);
        limits.checkLimits(counters);

        Assert.assertThrows(
                () -> limits.checkLimits(new LimitingCountersValue(11, 2, 3, 4)),
                AccessRateLimitException.class
        );
    }

    @Test
    public void byClientAndDb() {
        AccessRateLimits limits = new AccessRateLimits(AccessRateLimits.Type.BY_CLIENT, "app", Option.of("db"), 10);
        LimitingCountersValue counters;

        counters = new LimitingCountersValue(1, 2, 3, 4);
        limits.checkLimits(counters);

        counters = new LimitingCountersValue(100, 2, 3, 4);
        limits.checkLimits(counters);

        counters = new LimitingCountersValue(1, 10, 3, 4);
        limits.checkLimits(counters);

        Assert.assertThrows(
                () -> limits.checkLimits(new LimitingCountersValue(1, 11, 3, 4)),
                AccessRateLimitException.class
        );
    }

    @Test
    public void byHost() {
        AccessRateLimits limits = new AccessRateLimits(AccessRateLimits.Type.BY_HOST, "app", Option.empty(), 10);
        LimitingCountersValue counters;

        counters = new LimitingCountersValue(1, 2, 3, 4);
        limits.checkLimits(counters);

        counters = new LimitingCountersValue(1, 2, 3, 400);
        limits.checkLimits(counters);

        counters = new LimitingCountersValue(1, 2, 10, 4);
        limits.checkLimits(counters);

        Assert.assertThrows(
                () -> limits.checkLimits(new LimitingCountersValue(1, 2, 11, 4)),
                AccessRateLimitException.class
        );
    }

    @Test
    public void byHostAndDb() {
        AccessRateLimits limits = new AccessRateLimits(AccessRateLimits.Type.BY_HOST, "app", Option.of("db"), 10);
        LimitingCountersValue counters;

        counters = new LimitingCountersValue(1, 2, 3, 4);
        limits.checkLimits(counters);

        counters = new LimitingCountersValue(1, 2, 300, 4);
        limits.checkLimits(counters);

        counters = new LimitingCountersValue(1, 10, 3, 10);
        limits.checkLimits(counters);

        Assert.assertThrows(
                () -> limits.checkLimits(new LimitingCountersValue(1, 1, 3, 11)),
                AccessRateLimitException.class
        );
    }
}
