package ru.yandex.chemodan.app.dataapi.core.limiter.access;

import ru.yandex.chemodan.app.dataapi.utils.HttpStatusCodeSourceWithErrorLevel;
import ru.yandex.chemodan.util.exception.A3ExceptionWithNoStackTrace;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author tolmalev
 */
public class AccessRateLimitException extends A3ExceptionWithNoStackTrace implements HttpStatusCodeSourceWithErrorLevel {
    public AccessRateLimitException(String message) {
        super(ru.yandex.chemodan.util.web.ErrorNames.ACCESS_RATE_LIMIT_REACHED, message);
    }

    @Override
    public int getHttpStatusCode() {
        return HttpStatus.SC_507_INSUFFICIENT_STORAGE;
    }

}
