package ru.yandex.chemodan.app.dataapi.core.limiter.access;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author tolmalev
 */
@BenderBindAllFields
public class AccessRateLimits extends DefaultObject {
    public final Type type;
    public final String app;
    public final Option<String> databaseId;

    public final int threadsLimit;

    public AccessRateLimits(Type type, String app, Option<String> databaseId, int threadsLimit) {
        this.type = type;
        this.app = app;
        this.databaseId = databaseId;
        this.threadsLimit = threadsLimit;
    }

    public void checkLimits(LimitingCountersValue counters) {
        int counterValue = type.getCounter(counters, databaseId.isPresent());
        if (counterValue > threadsLimit) {
            throw new AccessRateLimitException(StringUtils.format(
                    "Threads count limit reached for type={}, app={}, dbId={}. {} > {}",
                    type, app, databaseId, counterValue, threadsLimit
            ));
        }
    }

    public enum Type {
        BY_CLIENT {
            public int getCounter(LimitingCountersValue counters, boolean forDatabase) {
                return forDatabase
                        ? counters.clientToDatabase
                        : counters.client;
            }
        },
        BY_HOST {
            public int getCounter(LimitingCountersValue counters, boolean forDatabase) {
                return forDatabase
                        ? counters.hostDatabase
                        : counters.hostApp;
            }
        };

        public abstract int getCounter(LimitingCountersValue counters, boolean forDatabase);
    }
}
