package ru.yandex.chemodan.app.dataapi.core.limiter.access;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.DataApiBenderUtils;
import ru.yandex.chemodan.app.dataapi.api.db.ref.external.ExternalDatabaseAlias;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkRegistry;

/**
 * @author tolmalev
 */
public class AccessRateLimitsRegistry extends ZkRegistry<String, AccessRateLimits> {
    public AccessRateLimitsRegistry(ZkPath path) {
        super(path,
                DataApiBenderUtils.mapper().createParserSerializer(AccessRateLimits.class),
                AccessRateLimitsRegistry::id,
                s -> s
        );
    }

    public ListF<AccessRateLimits> getLimits(Option<String> clientAppO, Option<String> hostAppO, String databaseId) {

        String clientDbId = !clientAppO.isPresent() || !hostAppO.isPresent() || clientAppO.equals(hostAppO)
                ? databaseId
                : ExternalDatabaseAlias.generateId(hostAppO.get(), databaseId);

        return
                clientAppO.flatMap(clientApp ->
                    getO(id(AccessRateLimits.Type.BY_CLIENT, clientApp))
                            .plus(getO(id(AccessRateLimits.Type.BY_CLIENT, clientApp, Option.of(clientDbId))))
                ).plus(
                        hostAppO.flatMap(hostApp ->
                                getO(id(AccessRateLimits.Type.BY_HOST, hostApp))
                                .plus(getO(id(AccessRateLimits.Type.BY_HOST, hostApp, Option.of(databaseId))))
                        )
                );
    }

    public static String id(AccessRateLimits limits) {
        return id(limits.type, limits.app, limits.databaseId);
    }

    public static String id(AccessRateLimits.Type type, String app) {
        return id(type, app, Option.empty());
    }

    public static String id(AccessRateLimits.Type type, String app, Option<String> databaseId) {
        return type.toString().toLowerCase() + "_" + app + databaseId.map(s -> "_" + s).getOrElse("");
    }
}
