package ru.yandex.chemodan.app.dataapi.core.limiter.access;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.test.Assert;

import static org.mockito.Mockito.any;
import static org.mockito.Mockito.anyString;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

/**
 * @author tolmalev
 */
public class AccessRateLimitsRegistryTest {
    @Test
    public void getListOfLimits() {
        AccessRateLimitsRegistry registry = mock(AccessRateLimitsRegistry.class);

        when(registry.getLimits(any(), any(), any())).thenCallRealMethod();

        MapF<String, AccessRateLimits> map = Cf.list(
            new AccessRateLimits(AccessRateLimits.Type.BY_CLIENT, "app", Option.empty(), 30),
            new AccessRateLimits(AccessRateLimits.Type.BY_CLIENT, "app", Option.of(".ext.h_app@db"), 15),
            new AccessRateLimits(AccessRateLimits.Type.BY_HOST, "h_app", Option.empty(), 150),
            new AccessRateLimits(AccessRateLimits.Type.BY_HOST, "h_app", Option.of("db"), 10),
            new AccessRateLimits(AccessRateLimits.Type.BY_CLIENT, "app2", Option.empty(), 30),
            new AccessRateLimits(AccessRateLimits.Type.BY_CLIENT, "app3", Option.empty(), 30)
        ).toMapMappingToKey(AccessRateLimitsRegistry::id);

        when(registry.getO(anyString())).then(invocation -> map.getO((String) invocation.getArguments()[0]));


        ListF<AccessRateLimits> limits = registry.getLimits(Option.of("app"), Option.of("h_app"), "db");

        Assert.sizeIs(4, limits);

        Assert.in(new AccessRateLimits(AccessRateLimits.Type.BY_CLIENT, "app", Option.empty(), 30), limits);
        Assert.in(new AccessRateLimits(AccessRateLimits.Type.BY_CLIENT, "app", Option.of(".ext.h_app@db"), 15), limits);
        Assert.in(new AccessRateLimits(AccessRateLimits.Type.BY_HOST, "h_app", Option.empty(), 150), limits);
        Assert.in(new AccessRateLimits(AccessRateLimits.Type.BY_HOST, "h_app", Option.of("db"), 10), limits);
    }
}
