package ru.yandex.chemodan.app.dataapi.core.limiter.access;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.db.ref.external.ExternalDatabasesRegistry;
import ru.yandex.chemodan.app.dataapi.core.generic.TypeSettingsRegistry;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManagerImpl;
import ru.yandex.commune.dynproperties.DynamicPropertyManager;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;

/**
 * @author tolmalev
 */
@Configuration
public class DataApiAccessRateLimitContextConfiguration {

    @Bean
    public AccessRateLimitsRegistry accessRateLimitsRegistry(
            ZkManager zkManager,
            @Qualifier("zkRoot")
            ZkPath zkRoot)
    {
        AccessRateLimitsRegistry registry = new AccessRateLimitsRegistry(zkRoot.child("access-rate-limits"));
        zkManager.addClient(registry);
        return registry;
    }

    @Bean
    public DataApiAccessRateLimiter dataApiRateAccessLimiter(AccessRateLimitsRegistry registry) {
        return new DataApiAccessRateLimiter(registry);
    }

    @Autowired(required = false)
    private TypeSettingsRegistry typeSettingsRegistry;

    @Bean
    public DataApiManagerLimitingInvocationHandler dataApiManagerCountingInvocationHandler(
            DynamicPropertyManager dynamicPropertyManager,
            DataApiAccessRateLimiter dataApiAccessRateLimiter,
            DataApiManagerImpl dataApiManagerImpl,
            ExternalDatabasesRegistry externalDatabasesRegistry)
    {
        dynamicPropertyManager.addStaticFields(DataApiManagerLimitingInvocationHandler.class);
        return new DataApiManagerLimitingInvocationHandler(dataApiManagerImpl, dataApiAccessRateLimiter,
                externalDatabasesRegistry, Option.ofNullable(typeSettingsRegistry));
    }
}
