package ru.yandex.chemodan.app.dataapi.core.limiter.access;

import ru.yandex.bolts.collection.Option;

/**
 * @author tolmalev
 */
public class DataApiAccessRateLimiter {
    private final AccessRateLimitsRegistry registry;

    public DataApiAccessRateLimiter(AccessRateLimitsRegistry registry) {
        this.registry = registry;
    }

    public void checkLimits(Option<String> clientAppO, Option<String> hostAppO, String databaseId,
            LimitingCountersValue counters)
    {
        registry
                .getLimits(clientAppO, hostAppO, databaseId)
                .forEach(limits -> limits.checkLimits(counters));
    }
}
